/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class DilapidationModifier
extends Modifier
implements BreakSpeedModifierHook,
BlockBreakModifierHook {
    private final ResourceLocation X = new ResourceLocation("tinkersinnovation", "dilapidation_x");
    private final ResourceLocation Y = new ResourceLocation("tinkersinnovation", "dilapidation_y");
    private final ResourceLocation Z = new ResourceLocation("tinkersinnovation", "dilapidation_z");
    private final ResourceLocation WORLD = new ResourceLocation("tinkersinnovation", "dilapidation_dimension");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.BREAK_SPEED, ModifierHooks.BLOCK_BREAK);
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (event.getPosition().isPresent()) {
            String world = event.getEntity().f_19853_.m_46472_().m_135782_().m_135815_();
            BlockPos pos = (BlockPos)event.getPosition().get();
            ModDataNBT data = tool.getPersistentData();
            if (data.contains(this.X, 5) && data.contains(this.Y, 5) && data.contains(this.Z, 5) && data.contains(this.WORLD, 8) && data.getString(this.WORLD).equals(world) && TinkersInnovationUtils.manhattanDistance(data.getFloat(this.X), data.getFloat(this.Y), data.getFloat(this.Z), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) <= (float)(1 + modifier.getLevel())) {
                event.setNewSpeed(1.5f * event.getNewSpeed());
            }
        }
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        BlockPos pos = context.getTargetedPos();
        ModDataNBT data = tool.getPersistentData();
        data.putFloat(this.X, (float)pos.m_123341_());
        data.putFloat(this.Y, (float)pos.m_123342_());
        data.putFloat(this.Z, (float)pos.m_123343_());
        data.putString(this.WORLD, context.getLiving().f_19853_.m_46472_().m_135782_().m_135815_());
    }
}

